/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.blocks.tiles;

import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityLockableLoot;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import noppes.npcs.CustomNpcs;
import noppes.npcs.blocks.CustomChest;
import noppes.npcs.containers.ContainerChestCustom;
import noppes.npcs.reflection.util.SoundEventReflection;

public class CustomTileEntityChest
extends TileEntityLockableLoot
implements ITickable {
    public float lidAngle;
    public float prevLidAngle;
    public NonNullList<ItemStack> inventory;
    public ResourceLocation chestTexture;
    private int size;
    private int numPlayersUsing = 0;
    public int guiColor = -1;
    public boolean isChest;
    private String name;
    private String blockName;
    public int[] guiColorArr;
    public SoundEvent sound_open = SoundEvents.field_187657_V;
    public SoundEvent sound_close = SoundEvents.field_187651_T;

    public CustomTileEntityChest() {
        this.setBlock(new CustomChest(Material.field_151575_d, new NBTTagCompound()));
    }

    public void func_174886_c(@Nonnull EntityPlayer player) {
        if (this.field_145850_b == null) {
            return;
        }
        --this.numPlayersUsing;
        this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, this.numPlayersUsing);
        this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), false);
    }

    public CustomTileEntityChest copy() {
        CustomTileEntityChest ctec = new CustomTileEntityChest();
        ctec.func_145839_a(this.func_189515_b(new NBTTagCompound()));
        return ctec;
    }

    @Nonnull
    public Container func_174876_a(@Nonnull InventoryPlayer playerInventory, @Nonnull EntityPlayer playerIn) {
        this.func_184281_d(playerIn);
        return new ContainerChestCustom(playerInventory, this, playerIn);
    }

    @Nonnull
    public String func_174875_k() {
        return this.blockName;
    }

    public int func_70297_j_() {
        return 64;
    }

    @Nonnull
    protected NonNullList<ItemStack> func_190576_q() {
        return this.inventory;
    }

    @Nonnull
    public String func_70005_c_() {
        if (this.name.isEmpty()) {
            return "custom.chest.chestexample";
        }
        return this.name;
    }

    public int func_70302_i_() {
        return this.inventory.size();
    }

    public boolean func_191420_l() {
        for (ItemStack stack : this.inventory) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public void func_174889_b(@Nonnull EntityPlayer player) {
        if (this.inventory == null || this.field_145850_b == null) {
            return;
        }
        ++this.numPlayersUsing;
        this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, this.numPlayersUsing);
        this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), false);
    }

    public void func_145839_a(@Nonnull NBTTagCompound compound) {
        SoundEvent soundclose;
        super.func_145839_a(compound);
        if (!compound.func_150297_b("Items", 9)) {
            return;
        }
        this.isChest = compound.func_74767_n("IsChest");
        this.guiColor = -1;
        this.guiColorArr = null;
        this.name = compound.func_74779_i("CustomName");
        this.size = compound.func_74762_e("Size");
        if (compound.func_150297_b("Texture", 8)) {
            this.chestTexture = new ResourceLocation(compound.func_74779_i("Texture"));
        }
        if (compound.func_150297_b("GUIColor", 11)) {
            this.guiColorArr = compound.func_74759_k("GUIColor");
        } else if (compound.func_150297_b("GUIColor", 3)) {
            this.guiColor = compound.func_74762_e("GUIColor");
        }
        SoundEvent soundopen = (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation(compound.func_74779_i("SoundOpen")));
        if (soundopen != null) {
            this.sound_open = soundopen;
        }
        if ((soundclose = (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation(compound.func_74779_i("SoundClose")))) != null) {
            this.sound_close = soundclose;
        }
        if (this.size != this.inventory.size()) {
            this.inventory = NonNullList.func_191197_a((int)this.size, (Object)ItemStack.field_190927_a);
        }
        this.inventory.clear();
        ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.inventory);
    }

    public void setBlock(CustomChest block) {
        this.field_145854_h = block;
        this.isChest = block.isChest;
        this.name = "custom.chest." + block.getCustomName();
        this.size = 9;
        this.blockName = Objects.requireNonNull(block.getRegistryName()).toString();
        this.chestTexture = block.nbtData.func_150296_c().isEmpty() ? null : new ResourceLocation("customnpcs", "textures/entity/chest/" + block.getRegistryName().func_110623_a() + ".png");
        this.guiColor = -1;
        this.guiColorArr = null;
        if (block.nbtData.func_150297_b("Name", 8)) {
            this.name = block.nbtData.func_74779_i("Name");
        }
        if (block.nbtData.func_150297_b("Size", 3)) {
            this.size = block.nbtData.func_74762_e("Size");
        }
        if (block.nbtData.func_150297_b("GUIColor", 3)) {
            this.guiColor = block.nbtData.func_74762_e("GUIColor");
        }
        if (block.nbtData.func_150297_b("GUIColor", 11)) {
            this.guiColor = -1;
            this.guiColorArr = block.nbtData.func_74759_k("GUIColor");
        }
        if (this.size > 189) {
            this.size = 189;
        }
        this.inventory = NonNullList.func_191197_a((int)this.size, (Object)ItemStack.field_190927_a);
    }

    public void func_73660_a() {
        if ((this.inventory.isEmpty() || this.chestTexture == null) && this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                CustomNpcs.proxy.fixTileEntityData((TileEntity)this);
            }
            return;
        }
        if (this.numPlayersUsing < 0) {
            this.numPlayersUsing = 0;
        }
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && this.numPlayersUsing != 0 && (this.field_145850_b.func_82737_E() + (long)this.field_174879_c.func_177958_n() + (long)this.field_174879_c.func_177956_o() + (long)this.field_174879_c.func_177952_p()) % 20L == 0L) {
            this.numPlayersUsing = 0;
            for (EntityPlayer entityplayer : this.field_145850_b.func_72872_a(EntityPlayer.class, new AxisAlignedBB((double)((float)this.field_174879_c.func_177958_n() - 5.0f), (double)((float)this.field_174879_c.func_177956_o() - 5.0f), (double)((float)this.field_174879_c.func_177952_p() - 5.0f), (double)((float)(this.field_174879_c.func_177958_n() + 1) + 5.0f), (double)((float)(this.field_174879_c.func_177956_o() + 1) + 5.0f), (double)((float)(this.field_174879_c.func_177952_p() + 1) + 5.0f)))) {
                if (!(entityplayer.field_71070_bA instanceof ContainerChestCustom) || !((ContainerChestCustom)entityplayer.field_71070_bA).getPos().equals((Object)this.field_174879_c)) continue;
                ++this.numPlayersUsing;
            }
        }
        this.prevLidAngle = this.lidAngle;
        if (this.numPlayersUsing > 0 && this.lidAngle == 0.0f) {
            double d1 = (double)this.field_174879_c.func_177958_n() + 0.5;
            double d2 = (double)this.field_174879_c.func_177952_p() + 0.5;
            this.field_145850_b.func_184148_a(null, d1, (double)this.field_174879_c.func_177956_o() + 0.5, d2, this.sound_open, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        if (this.numPlayersUsing == 0 && this.lidAngle > 0.0f || this.numPlayersUsing > 0 && this.lidAngle < 1.0f) {
            float f2 = this.lidAngle;
            this.lidAngle = this.numPlayersUsing > 0 ? (this.lidAngle += 0.1f) : (this.lidAngle -= 0.1f);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            if (this.lidAngle < 0.5f && f2 >= 0.5f) {
                double d3 = (double)this.field_174879_c.func_177958_n() + 0.5;
                double d0 = (double)this.field_174879_c.func_177952_p() + 0.5;
                this.field_145850_b.func_184148_a(null, d3, (double)this.field_174879_c.func_177956_o() + 0.5, d0, this.sound_close, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
    }

    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74757_a("IsChest", this.isChest);
        compound.func_74768_a("Size", this.size);
        compound.func_74778_a("CustomName", this.name.isEmpty() ? "custom.chest.chestexample" : this.name);
        if (this.chestTexture != null) {
            compound.func_74778_a("Texture", this.chestTexture.toString());
        }
        if (this.guiColor != -1) {
            compound.func_74768_a("GUIColor", this.guiColor);
        }
        if (this.guiColorArr != null) {
            compound.func_74783_a("GUIColor", this.guiColorArr);
        }
        compound.func_74778_a("SoundOpen", SoundEventReflection.getSoundName(this.sound_open).toString());
        compound.func_74778_a("SoundClose", SoundEventReflection.getSoundName(this.sound_close).toString());
        ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.inventory);
        return compound;
    }
}

